from flask import Flask, render_template_string, request, send_from_directory
import os

app = Flask(__name__)

@app.route('/', methods=['GET', 'POST'])
def home():
    with open('templates/index.html', 'r') as f:
        template = f.read()
    
    if request.method == 'POST':
        user_input = request.form['user_input']
        return render_template_string(template.format(user_input=user_input))
    return render_template_string(template.format(user_input='Your input will show here'))

@app.route('/download')
def download_file():
    directory = os.getcwd() 
    filename = "chall.zip"
    return send_from_directory(directory, filename, as_attachment=True)

if __name__ == '__main__':
    app.run(debug=False, host='0.0.0.0')
